<?php 
Class Stripe 
{
	public function __construct($config = array()) {
		$this->config = $config;
		$this->validation();
	}

	public function plan_create($input){
		$init = array();
		$init['url']= "https://api.stripe.com/v1/plans";
		$post_query = http_build_query($input, '', '&');
		$init['post_data'] = $post_query; 
		return $this->curl_init($init);		
	}

	public function customer_create($input){
		$init = array();
		$init['url']= "https://api.stripe.com/v1/customers";	
		$post_query = http_build_query($input, '', '&');
		$init['post_data'] = $post_query;
		return $this->curl_init($init);
	}

	public function subscribe_customer($input){
		$init = array();
		$init['url']= "https://api.stripe.com/v1/subscriptions";
		$post_query = http_build_query($input, '', '&');
		$init['post_data'] = $post_query; 
		return $this->curl_init($init);
	}

	public function stripe_charges($input){
		$init = array();
		$init['url']= "https://api.stripe.com/v1/charges";	
		$post_query = http_build_query($input, '', '&');
		$init['post_data'] = $post_query; 
		return $this->curl_init($init);
	}

	public function stripe_refund($input){
		$init = array();
		$init['url']= "https://api.stripe.com/v1/refunds";	
		$post_query = http_build_query($input, '', '&');
		$init['post_data'] = $post_query; 
		return $this->curl_init($init);
	}

	/*create card*/

	public function create_card($input,$cust_id){

		$init = array();

		$init['url']= "https://api.stripe.com/v1/customers/".$cust_id."/sources";	

		$post_query = http_build_query($input, '', '&');

		$init['post_data'] = $post_query;

		return $this->curl_init($init);

	}

	/*retrieve customer*/

	public function retrieve_customer($cust_id,$secret_key){
		// Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/
			$ch = curl_init();
			
			curl_setopt($ch, CURLOPT_URL, 'https://api.stripe.com/v1/customers/'.$cust_id);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
			
			curl_setopt($ch, CURLOPT_USERPWD, $secret_key. ":" . "");
			
			$result = curl_exec($ch);
			if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
			}
			curl_close($ch);
			return $result;
			}

	/*redrive card*/

	public function ext_retrieve_card(){
		// Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/
		$ch = curl_init();
		
		curl_setopt($ch, CURLOPT_URL, 'https://api.stripe.com/v1/accounts/acct_1032D82eZvKYlo2C/external_accounts/card_1GB9752eZvKYlo2CsmCSSeJg');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
		
		curl_setopt($ch, CURLOPT_USERPWD, $secret_key. ":" . "");
		
		$result = curl_exec($ch);
		if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
		}
		return curl_close($ch);


	}

	/*remove external card in provider*/

	public function delete_provider_ext_card($ac_no,$card_no){
		// Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/
$ch = curl_init();

curl_setopt($ch, CURLOPT_URL, "https://api.stripe.com/v1/accounts/".$ac_no."/external_accounts/".$card_no);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');

curl_setopt($ch, CURLOPT_USERPWD, $this->secret_key . ":" . "");
$result = curl_exec($ch);
if (curl_errno($ch)) {
    echo 'Error:' . curl_error($ch);
}
curl_close($ch);
	}

/*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\-----WITHDRAWAL CONCEPT ------/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\*/
    

    /*card removed option*/

    public function delete_card($cust_id,$card_id){ //customer card

    	// Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/
			$ch = curl_init();

			curl_setopt($ch, CURLOPT_URL, "https://api.stripe.com/v1/customers/".$cust_id."/sources/".$card_id);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');

			curl_setopt($ch, CURLOPT_USERPWD, $this->secret_key . ":" . "");

			$result = curl_exec($ch);
			if (curl_errno($ch)) {
			    echo 'Error:' . curl_error($ch);
			}
			return curl_close($ch);
    }
    /*update card info*/
    public function update_card($cust_id,$card_id){
    	// Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/
		$init = array();
		$init['url']= "https://api.stripe.com/v1/customers/".$cust_id."/sources/".$card_id;	
		$post_query = http_build_query($input, '', '&');
		$init['post_data'] = $post_query;
		return $this->curl_init($init);
    }

    /*get all customer related card*/
    public function customer_card_list($input,$cust_id){
    	// Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/
		$init = array();
		$init['url']= "https://api.stripe.com/v1/customers/".$cust_id."/sources";	
		$post_query = http_build_query($input, '', '&');
		$init['post_data'] = $post_query;
		return $this->curl_init($init);
    }

    /*create connection account in stripe*/
    public function create_connect_account($input){
    	// Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/
		$init = array();
		$init['url']= "https://api.stripe.com/v1/accounts";	
		$post_query = http_build_query($input, '', '&');
		$init['post_data'] = $post_query;
		return $this->curl_init($init);
    }

    /*created external account */

    public function create_external_card($input,$account){
		// Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/
		$init = array();
		$init['url']= "https://api.stripe.com/v1/accounts/".$account."/external_accounts";	
		$post_query = http_build_query($input, '', '&');
		$init['post_data'] = $post_query;
		return $this->curl_init($init);
    }

    /*remove external card from acc*/

    public function delete_card_external($account_id,$card_id){
			// Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/
			$ch = curl_init();
			// curl_setopt($ch, CURLOPT_URL, 'https://api.stripe.com/v1/accounts/acct_1032D82eZvKYlo2C/external_accounts/card_1GBvyL2eZvKYlo2CrBkpfDpO');
curl_setopt($ch, CURLOPT_URL, "https://api.stripe.com/v1/accounts/".$account_id."/external_accounts/".$card_id);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
			
			curl_setopt($ch, CURLOPT_USERPWD, 'sk_test_4eC39HqLyjWDarjtT1zdp7dc' . ':' . '');
			
			$result = curl_exec($ch);
			if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
			}
			return curl_close($ch);
    }

    /*transfer amount in formal*/

    public function transfer_wallet($input){
    	// Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/
		$init = array();
		$init['url']= "https://api.stripe.com/v1/transfers";	
		$post_query = http_build_query($input, '', '&');
		$init['post_data'] = $post_query;
		return $this->curl_init($init);

    }

    /*get token info*/

    public function get_stripe_token_info($token){
    	// Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/
$ch = curl_init();

curl_setopt($ch, CURLOPT_URL, "https://api.stripe.com/v1/tokens/".$token);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

curl_setopt($ch, CURLOPT_USERPWD, $this->secret_key . ":" . "");

$result = curl_exec($ch);
if (curl_errno($ch)) {
    echo 'Error:' . curl_error($ch);
}
return curl_close($ch);
    }

/*\/\/\/\/\/\/\/\/\//\/\/\/\/-----WITHDRAWAL CONCEPT ------/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\*/


	public function direct_charges($amount,$currency,$CONNECTED_STRIPE_ACCOUNT_ID,$secret_key){
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, "https://api.stripe.com/v1/charges");
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, "amount=".$amount."&currency=".strtolower($currency)."&source=tok_visa");
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_USERPWD, $secret_key. ":" . "");
		$headers = array();
		$headers[] = "Stripe-Account: {".$CONNECTED_STRIPE_ACCOUNT_ID."}";
		$headers[] = "Content-Type: application/x-www-form-urlencoded";
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		$result = curl_exec($ch);
		if (curl_errno($ch)) {
		$result =  'Error:' . curl_error($ch);
		}
		curl_close ($ch);
		return $result;
	}

	public function curl_init($option){
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $option['url']);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS,$option['post_data']);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_USERPWD, $this->secret_key . ":" . "");
		$headers = array();
		$headers[] = "Content-Type: application/x-www-form-urlencoded";
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		$result = array();
		$result = curl_exec($ch);
		if (curl_errno($ch)) {
			$result = curl_error($ch);
		}
		curl_close ($ch);
		return $result;
	}

	public function validation(){
		$this->publishable_key = (!empty($this->config['publishable_key'])?$this->config['publishable_key']:'');
		$this->secret_key      = (!empty($this->config['secret_key'])?$this->config['secret_key']:'');
		$this->stripe_name     = (!empty($this->config['stripe_name'])?$this->config['stripe_name']:'Stripe Payment');
		$this->server_side_coding = (!empty($this->config['server_side_coding'])?$this->config['server_side_coding']:'');
		$this->stripe_logo     = (!empty($this->config['stripe_logo'])?$this->config['stripe_logo']:'https://stripe.com/img/documentation/checkout/marketplace.png');
		$this->stripe_description = (!empty($this->config['stripe_description'])?$this->config['stripe_description']:'This is Stripe Payment');
		$error_message = array();
		if(empty($this->publishable_key)){
			$error_message['publishable_error'] = "Publishable key is missing";
		}
		if(empty($this->secret_key)){
			$error_message['secret_error'] = "The secret key is missing";
		}
		if(count($error_message) > 0){
			return json_encode($error_message);
		}
	}

	public function pay_with_card_form(){
		$pay_with_card_html = '<form action="'.$this->server_side_coding.'" method="POST" id="stripe_payment" style="display:none">
			<script src="https://checkout.stripe.com/checkout.js" class="stripe-button"
			data-key="'.$this->publishable_key.'"
			data-name="'.$this->stripe_name.'"
			data-billing-address="true"
			data-description="'.$this->stripe_description.'"
			data-image="'.$this->stripe_logo.'"
			data-locale="auto">
			</script>
			</form>'; 
		echo $pay_with_card_html;	
	}
}
?>